/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

// Created by Vinicius Graciano Santos - vgs/2014
// Based on the following websites:
// http://www.josleys.com/article_show.php?id=82
// http://iquilezles.org/www/articles/distancefractals/distancefractals.htm

#define ITER 256
#define R1 0.3
#define R2 2.0
#define TAU 6.28318530718

vec2 droste(in vec2 uv) {
	float alpha = -atan(log(R2/R1)/TAU) - 0.586; // try alpha = 0.0 or delete -0.586.
	vec2 rot = vec2(cos(alpha), sin(alpha));
	uv = vec2(log(length(uv)), atan(uv.y, uv.x));
	uv = vec2(uv.x*rot.x - uv.y*rot.y, uv.x*rot.y + uv.y*rot.x)/rot.x;
	uv.x = mod(uv.x, log(R2/R1));
	return R1*exp(uv.x)*vec2(cos(uv.y), sin(uv.y));
}

void main(void)
{
	float t = exp(-mod(0.1*iGlobalTime, 20.825)); // discontinuity :(
	vec2 z = vec2(0.0), dz = vec2(0.0);
	vec2 uv = droste(t*(-iResolution.xy+2.0*gl_FragCoord.xy)/iResolution.y);
	vec2 c = uv - vec2(0.4, 0.0);
	
	for (int i = 0; i < ITER; ++i) {
		if (dot(z, z) > 32.0) continue;
		dz = 2.0*vec2(z.x*dz.x - z.y*dz.y, z.x*dz.y + z.y*dz.x) + vec2(1.0, 0.0);
		z = vec2(z.x*z.x - z.y*z.y, 2.0*z.x*z.y) + c;		
	}
	float d = abs(length(uv) - R2);
	d *= dot(z, z) <= 32.0 ? 0.0 : 0.5*sqrt(dot(z,z)/dot(dz,dz))*log(dot(z,z));
	vec3 tex = 1.0-texture2D(iChannel0, uv).rgb; tex = 0.2+0.8*tex*tex*(3.0-2.0*tex);
	gl_FragColor = vec4(tex*vec3(pow(d, 0.18)),1.0);
}